--
-- c_uv_scroll.lua
--


addEventHandler( "onClientResourceStart", resourceRoot,
	function()

		-- Version check
		if getVersion ().sortable < "1.1.0" then
			outputChatBox( "Resource is not compatible with this client." )
			return
		end

		-- Create shader
		local shader, tec = dxCreateShader ( "uv_scroll.fx" )

		if not shader then
			outputChatBox( "Could not create shader. Please use debugscript 3" )
		else
			outputChatBox( "Using technique " .. tec )

			-- Apply to world texture
			engineApplyShaderToWorldTexture ( shader, "bobo_2" )

			-- Create object with model 4729 (billboard)
			local x,y,z = getElementPosition( getLocalPlayer() )
			createObject ( 4729, x-15, y, z+3 )
		end
	end
)
