//
// Example shader - uv_scroll.fx
//


///////////////////////////////////////////////////////////////////////////////
// Global variables
///////////////////////////////////////////////////////////////////////////////
float gTime : TIME;


///////////////////////////////////////////////////////////////////////////////
// Functions
///////////////////////////////////////////////////////////////////////////////

//-------------------------------------------
// Returns UV anim transform
//-------------------------------------------
float3x3 getTextureTransform ()
{
    float posU = -fmod( gTime/8 ,1 );    // Scroll Right
    float posV = 0;

    return float3x3(
                    1, 0, 0,
                    0, 1, 0,
                    posU, posV, 1
                    );
}


///////////////////////////////////////////////////////////////////////////////
// Techniques
///////////////////////////////////////////////////////////////////////////////
technique tec0
{
    pass P0
    {
        // Set the UV thingy
        TextureTransform[0] = getTextureTransform ();

        // Enable UV thingy
        TextureTransformFlags[0] = Count2;
    }
}
